<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T16:29:31.842637418 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A57" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Barrier Operations Percentage">
        <series color="19,148,180" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageCortexA57INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageCortexA57ISB_SPEC + $BarrierOperationsPercentageCortexA57DSB_SPEC) + $BarrierOperationsPercentageCortexA57DMB_SPEC) / $BarrierOperationsPercentageCortexA57INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch MPKI">
        <series color="19,148,180" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexA57INST_RETIRED &gt; 0), (($BranchMPKICortexA57BR_MIS_PRED / $BranchMPKICortexA57INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Operations Percentage">
        <series color="19,148,180" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageCortexA57INST_SPEC &gt; 0), min((($BranchOperationsPercentageCortexA57BR_IMMED_SPEC + $BranchOperationsPercentageCortexA57BR_INDIRECT_SPEC) / $BranchOperationsPercentageCortexA57INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Cycles Per Instruction">
        <series color="19,148,180" description="This metric measures the number of cycles per instructions retired" expression="if(($CyclesPerInstructionCortexA57INST_RETIRED &gt; 0), ($CyclesPerInstructionCortexA57CPU_CYCLES / $CyclesPerInstructionCortexA57INST_RETIRED), 0)" name="Cycles Per Instruction" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Crypto Operations Percentage">
        <series color="19,148,180" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexA57INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexA57CRYPTO_SPEC / $CryptoOperationsPercentageCortexA57INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexA57INST_SPEC &gt; 0), min((($IntegerOperationsPercentageCortexA57DP_SPEC - $IntegerOperationsPercentageCortexA57DSB_SPEC) / $IntegerOperationsPercentageCortexA57INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions Per Cycle">
        <series color="19,148,180" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexA57CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexA57INST_RETIRED / $InstructionsPerCycleCortexA57CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache Demand MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheDemandMPKICortexA57INST_RETIRED &gt; 0), ((($L1DCacheDemandMPKICortexA57L1D_CACHE_REFILL_RD + $L1DCacheDemandMPKICortexA57L1D_CACHE_REFILL_WR) / $L1DCacheDemandMPKICortexA57INST_RETIRED) * 1000), 0)" name="L1D Cache Demand MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexA57L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexA57L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexA57L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexA57INST_RETIRED &gt; 0), (($L1DCacheMPKICortexA57L1D_CACHE_REFILL / $L1DCacheMPKICortexA57INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexA57INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexA57L1D_TLB_REFILL / $L1DataTLBMPKICortexA57INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1I Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexA57L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexA57L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexA57L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1I Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexA57INST_RETIRED &gt; 0), (($L1ICacheMPKICortexA57L1I_CACHE_REFILL / $L1ICacheMPKICortexA57INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexA57INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexA57L1I_TLB_REFILL / $L1InstructionTLBMPKICortexA57INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageCortexA57L2D_CACHE &gt; 0), min(($L2CacheMissPercentageCortexA57L2D_CACHE_REFILL / $L2CacheMissPercentageCortexA57L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexA57INST_RETIRED &gt; 0), (($L2CacheMPKICortexA57L2D_CACHE_REFILL / $L2CacheMPKICortexA57INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache Demand MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data demand accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheDemandMPKICortexA57INST_RETIRED &gt; 0), ((($L2DCacheDemandMPKICortexA57L2D_CACHE_REFILL_RD + $L2DCacheDemandMPKICortexA57L2D_CACHE_REFILL_WR) / $L2DCacheDemandMPKICortexA57INST_RETIRED) * 1000), 0)" name="L2D Cache Demand MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache data accesses missed to the total number of level 2 data cache accesses. This gives an indication of the effectiveness of data accesses in the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMissPercentageCortexA57L2D_CACHE &gt; 0), min(($L2DCacheMissPercentageCortexA57L2D_CACHE_REFILL / $L2DCacheMissPercentageCortexA57L2D_CACHE), 1), 0)" name="L2D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMPKICortexA57INST_RETIRED &gt; 0), (($L2DCacheMPKICortexA57L2D_CACHE_REFILL / $L2DCacheMPKICortexA57INST_RETIRED) * 1000), 0)" name="L2D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageCortexA57INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageCortexA57LDREX_SPEC / $LoadExclusiveInstructionsPercentageCortexA57INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load as Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageCortexA57LDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageCortexA57LD_SPEC / $LoadAsLoadStoreOperationsPercentageCortexA57LDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexA57INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexA57LD_SPEC / $LoadOperationsPercentageCortexA57INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageCortexA57INST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageCortexA57LDST_SPEC / $LoadStoreOperationsPercentageCortexA57INST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Acquire Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageCortexA57INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageCortexA57RC_LD_SPEC / $LoadAcquireInstructionsPercentageCortexA57INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Release Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageCortexA57INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageCortexA57RC_ST_SPEC / $StoreReleaseInstructionsPercentageCortexA57INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retired Instructions Percentage">
        <series color="19,148,180" description="This metric measures the percentage of instructions speculatively executed that are subsequently retired" expression="if(($RetiredInstructionsPercentageCortexA57INST_SPEC &gt; 0), min(($RetiredInstructionsPercentageCortexA57INST_RETIRED / $RetiredInstructionsPercentageCortexA57INST_SPEC), 1), 0)" name="Retired Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexA57INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexA57VFP_SPEC / $FloatingPointOperationsPercentageCortexA57INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Advanced SIMD Operations Percentage">
        <series color="19,148,180" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexA57INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexA57ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexA57INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store as Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageCortexA57LDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageCortexA57ST_SPEC / $StoreAsLoadStoreOperationsPercentageCortexA57LDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexA57INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexA57ST_SPEC / $StoreOperationsPercentageCortexA57INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Store-Exclusive Failures PKI">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed per thousand instructions speculatively executed" expression="if(($StoreExclusiveFailuresPKICortexA57INST_SPEC &gt; 0), (($StoreExclusiveFailuresPKICortexA57STREX_FAIL_SPEC / $StoreExclusiveFailuresPKICortexA57INST_SPEC) * 1000), 0)" name="Store-Exclusive Failures PKI" units="failures"/>
    </chart>
    <select-metric id="ARMv8_Cortex_A57_metric_barrier_percentage" />
    <select-metric id="ARMv8_Cortex_A57_metric_branch_mpki" />
    <select-metric id="ARMv8_Cortex_A57_metric_branch_percentage" />
    <select-metric id="ARMv8_Cortex_A57_metric_cpi" />
    <select-metric id="ARMv8_Cortex_A57_metric_crypto_percentage" />
    <select-metric id="ARMv8_Cortex_A57_metric_integer_dp_percentage" />
    <select-metric id="ARMv8_Cortex_A57_metric_ipc" />
    <select-metric id="ARMv8_Cortex_A57_metric_l1d_cache_demand_mpki" />
    <select-metric id="ARMv8_Cortex_A57_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A57_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A57_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A57_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A57_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A57_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A57_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A57_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A57_metric_l2d_cache_demand_mpki" />
    <select-metric id="ARMv8_Cortex_A57_metric_l2d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A57_metric_l2d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A57_metric_ldrex_percentage" />
    <select-metric id="ARMv8_Cortex_A57_metric_load_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A57_metric_load_percentage" />
    <select-metric id="ARMv8_Cortex_A57_metric_load_store_percentage" />
    <select-metric id="ARMv8_Cortex_A57_metric_rc_ld_percentage" />
    <select-metric id="ARMv8_Cortex_A57_metric_rc_st_percentage" />
    <select-metric id="ARMv8_Cortex_A57_metric_retired_insns_percent" />
    <select-metric id="ARMv8_Cortex_A57_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Cortex_A57_metric_simd_percentage" />
    <select-metric id="ARMv8_Cortex_A57_metric_store_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A57_metric_store_percentage" />
    <select-metric id="ARMv8_Cortex_A57_metric_strex_fail_mpki" />
</template>
